/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.potions;

import com.megacrit.cardcrawl.actions.common.GainEnergyAction;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.PowerTip;
import com.megacrit.cardcrawl.localization.PotionStrings;
import com.megacrit.cardcrawl.potions.AbstractPotion;

public class EnergyPotion
extends AbstractPotion {
    public static final String POTION_ID = "Energy Potion";
    private static final PotionStrings potionStrings = CardCrawlGame.languagePack.getPotionString("Energy Potion");
    public static final String NAME = EnergyPotion.potionStrings.NAME;
    public static final String[] DESCRIPTIONS = EnergyPotion.potionStrings.DESCRIPTIONS;

    public EnergyPotion() {
        super(NAME, POTION_ID, AbstractPotion.PotionSize.M, AbstractPotion.PotionColor.ENERGY);
        this.potency = 2;
        this.description = DESCRIPTIONS[0] + this.potency + DESCRIPTIONS[1];
        this.isThrown = false;
        this.tips.add(new PowerTip(this.name, this.description));
    }

    @Override
    public void use(AbstractCreature target) {
        AbstractDungeon.actionManager.addToBottom(new GainEnergyAction(this.potency));
    }

    @Override
    public AbstractPotion makeCopy() {
        return new EnergyPotion();
    }
}

